unit config;

interface

uses
  Windows, Controls, Forms, Dialogs, StdCtrls, Classes, FileCtrl, Inifiles,
  SysUtils, childwin, explorateur;


type
  TOptions = class(TForm)
    label_langue: TLabel;
    choix_langue: TComboBox;
    cmd_choix_rep_travail: TButton;
    label_repertoire_travail: TLabel;
    repertoire_travail: TStaticText;
    Label_nom_dest: TLabel;
    Label_nom_zip: TLabel;
    choix_format_dest_nom: TComboBox;
    choix_format_dest_extension: TComboBox;
    choix_format_zip_nom: TComboBox;
    choix_format_zip_extension: TComboBox;
    procedure FormCreate(Sender: TObject);
    procedure choix_langueChange(Sender: TObject);
    procedure choix_format_dest_nomChange(Sender: TObject);
    procedure choix_format_dest_extensionChange(Sender: TObject);
    procedure cmd_choix_rep_travailClick(Sender: TObject);
    procedure FormDeactivate(Sender: TObject);
    procedure choix_format_zip_nomChange(Sender: TObject);
    procedure choix_format_zip_extensionChange(Sender: TObject);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
  end;

var
  Options: TOptions;
  fichierini:tmeminifile;

//Lecture du fichier de configuration
procedure lire_fichier_config; forward;
//Config de chaque fentre
procedure lit_ini_main; forward;
procedure ecrit_ini_main; forward;
procedure lit_ini_childwin(fenetre:tmdichild); forward;
procedure ecrit_ini_childwin(fenetre:tmdichild); forward;
procedure lit_ini_conversion; forward;
procedure ecrit_ini_conversion; forward;
procedure lit_ini_disquette_vierge; forward;
procedure ecrit_ini_disquette_vierge; forward;
procedure lit_ini_explorateur(fenetre:texplorer); forward;
procedure ecrit_ini_explorateur(fenetre:texplorer); forward;

implementation

uses main, conversion, disque_vierge, scan_disk, traduction, tout;


{$R *.dfm}

//-------------------------------------------------------------------------------------------
//Cration de la fentre
procedure TOptions.FormCreate(Sender: TObject);
begin
    traduction_textes_parametres;
    repertoire_travail.Caption :=rep_travail;
    choix_langue.ItemIndex:=langue;
    choix_format_dest_nom.ItemIndex:=format_nom_dest;
    choix_format_dest_extension.ItemIndex:=format_ext_dest;
    choix_format_zip_nom.ItemIndex:=format_nom_zip;
    choix_format_zip_extension.ItemIndex:=format_ext_zip;
end;

//-------------------------------------------------------------------------------------------
//Changement de langue
procedure TOptions.choix_langueChange(Sender: TObject);
begin
    langue:=choix_langue.ItemIndex;
end;

//-------------------------------------------------------------------------------------------
//Changement de format de casse du nom de destination pour conversion
procedure TOptions.choix_format_dest_nomChange(Sender: TObject);
begin
    format_nom_dest:=choix_format_dest_nom.ItemIndex;
end;

//-------------------------------------------------------------------------------------------
//Changement de format de casse de l'extension du nom de destination pour conversion
procedure TOptions.choix_format_dest_extensionChange(Sender: TObject);
begin
    format_ext_dest:=choix_format_dest_extension.ItemIndex;
end;

//-------------------------------------------------------------------------------------------
//Changement de format de casse du nom de l'archive zip
procedure TOptions.choix_format_zip_nomChange(Sender: TObject);
begin
    format_nom_zip:=choix_format_zip_nom.ItemIndex;
end;

//-------------------------------------------------------------------------------------------
//Changement de format de casse de l'extension du nom de l'archive zip
procedure TOptions.choix_format_zip_extensionChange(Sender: TObject);
begin
    format_ext_zip:=choix_format_zip_extension.ItemIndex;
end;

//-------------------------------------------------------------------------------------------
//Choix du rpertoire de travail
procedure TOptions.cmd_choix_rep_travailClick(Sender: TObject);
var
    repertoire:string;

begin
    if SelectDirectory(textes_parametres[4],'',repertoire)=true then
        rep_travail:=repertoire;
    if rep_travail[length(rep_travail)]<>'\' then rep_travail:=rep_travail+'\';
    repertoire_travail.Caption :=rep_travail;

end;

//-------------------------------------------------------------------------------------------
//Fermeture de la fentre  la perte de la focalisation
procedure TOptions.FormDeactivate(Sender: TObject);
begin
    close;
end;

//-------------------------------------------------------------------------------------------
//Lecture des donnes du fichier ini
procedure lire_fichier_config;
begin
    fichierini:=tmeminifile.Create(rep_app+'msa_converter.ini');
    lit_ini_main;
end;

//Lecture des paramtres de la fentre principale
procedure lit_ini_main;
var
    strtemp:string;

begin
    { Boolean - lecture de valeurs de type boolen : }

    { Integer - lecture de valeurs de type entier : }
    langue:=fichierini.ReadInteger('main', 'langue', 0);
    format_nom_dest:=fichierini.ReadInteger('main', 'format_nom_dest',0);
    format_ext_dest:=fichierini.ReadInteger('main', 'format_ext_dest',0);
    format_nom_zip:=fichierini.ReadInteger('main', 'format_nom_zip',0);
    format_ext_zip:=fichierini.ReadInteger('main', 'format_ext_zip',0);
    msa_converter.Top:=fichierini.ReadInteger('main','top',133);
    msa_converter.Left:=fichierini.ReadInteger('main','left',280);
    msa_converter.Width:=fichierini.ReadInteger('main','width',580);
    msa_converter.Height:=fichierini.ReadInteger('main','height',618);

    { String - lecture de valeurs de type chane : }
    rep_travail:=fichierini.ReadString('main','rep_travail',rep_app);
    rep_utilisateur:=fichierini.ReadString('main','rep_utilisateur',rep_app);
    strtemp:=fichierini.ReadString('main','windowstate','normal');
    if strtemp='maximized' then msa_converter.WindowState:=wsmaximized;

    change_langue_application;
end;

//Ecriture des paramtres de la fentre principale
procedure ecrit_ini_main;
var
    strtemp:string;

begin
    { Boolean - criture de valeurs de type boolen : }

    { Integer - criture de valeurs de type entier : }
    fichierini.WriteInteger('main', 'langue', langue);
    fichierini.WriteInteger('main', 'format_nom_dest', format_nom_dest);
    fichierini.WriteInteger('main', 'format_ext_dest', format_ext_dest);
    fichierini.WriteInteger('main', 'format_nom_zip', format_nom_zip);
    fichierini.WriteInteger('main', 'format_ext_zip', format_ext_zip);
    if msa_converter.WindowState<>wsmaximized then
    begin
        fichierini.WriteInteger('main','top',msa_converter.Top);
        fichierini.WriteInteger('main','left',msa_converter.Left);
        fichierini.WriteInteger('main','width',msa_converter.Width);
        fichierini.WriteInteger('main','height',msa_converter.Height);
    end;

    { String - criture de valeurs de type chane : }
    fichierini.WriteString('main','rep_travail',rep_travail);
    fichierini.WriteString('main','rep_utilisateur',rep_utilisateur);
    if msa_converter.WindowState=wsmaximized then strtemp:='maximized' else strtemp:='normal';
    fichierini.WriteString('main','windowstate',strtemp);
end;

//Lecture des paramtres de la fentre image disque
procedure lit_ini_childwin(fenetre:tmdichild);
var
    strtemp:string;

begin
    { Boolean - lecture de valeurs de type boolen : }

    { Integer - lecture de valeurs de type entier : }
//    fenetre.Top:=fichierini.ReadInteger('childwin','top',146);
//    fenetre.Left:=fichierini.ReadInteger('childwin','left',313);
    fenetre.Width:=fichierini.ReadInteger('childwin','width',533);
    fenetre.Height:=fichierini.ReadInteger('childwin','height',450);
    fenetre.dossiers.Width :=fichierini.ReadInteger('childwin','largeur_contenu',137);
    fenetre.contenu_repertoire.Columns[0].Width:=fichierini.ReadInteger('childwin','largeur_nom',100);
    fenetre.contenu_repertoire.Columns[1].Width:=fichierini.ReadInteger('childwin','largeur_taille',75);
    fenetre.contenu_repertoire.Columns[2].Width:=fichierini.ReadInteger('childwin','largeur_attr',50);
    fenetre.contenu_repertoire.Columns[3].Width:=fichierini.ReadInteger('childwin','largeur_heure',70);
    fenetre.contenu_repertoire.Columns[4].Width:=fichierini.ReadInteger('childwin','largeur_date',70);

    { String - lecture de valeurs de type chane : }
    strtemp:=fichierini.ReadString('childwin','windowstate','normal');
    if strtemp='maximized' then fenetre.WindowState:=wsmaximized;
end;

//Ecriture des paramtres de la fentre image disque
procedure ecrit_ini_childwin(fenetre:tmdichild);
var
    strtemp:string;

begin
    { Boolean - criture de valeurs de type boolen : }

    { Integer - criture de valeurs de type entier : }
    if fenetre.WindowState<>wsmaximized then
    begin
//        fichierini.WriteInteger('childwin','top',fenetre.Top);
//        fichierini.WriteInteger('childwin','left',fenetre.Left);
        fichierini.WriteInteger('childwin','width',fenetre.Width);
        fichierini.WriteInteger('childwin','height',fenetre.Height);
    end;
    fichierini.WriteInteger('childwin','largeur_contenu',fenetre.dossiers.Width);
    fichierini.WriteInteger('childwin','largeur_nom',fenetre.contenu_repertoire.Columns[0].Width);
    fichierini.WriteInteger('childwin','largeur_taille',fenetre.contenu_repertoire.Columns[1].Width);
    fichierini.WriteInteger('childwin','largeur_attr',fenetre.contenu_repertoire.Columns[2].Width);
    fichierini.WriteInteger('childwin','largeur_heure',fenetre.contenu_repertoire.Columns[3].Width);
    fichierini.WriteInteger('childwin','largeur_date',fenetre.contenu_repertoire.Columns[4].Width);

    { String - criture de valeurs de type chane : }
    if fenetre.WindowState=wsmaximized then strtemp:='maximized' else strtemp:='normal';
    fichierini.WriteString('childwin','windowstate',strtemp);

end;

//Lecture des paramtres de la fentre conversion
procedure lit_ini_conversion;
begin
    { Boolean - lecture de valeurs de type boolen : }
    convert.compresser.Checked :=fichierini.ReadBool('convert','compresser',true);
    convert.ecraser_sans_confirm.Checked :=fichierini.ReadBool('convert','ecraser',true);

    { Integer - lecture de valeurs de type entier : }
    convert.choix_nombre_msa.ItemIndex :=fichierini.ReadInteger('convert','nb_msa',0);

    { String - lecture de valeurs de type chane : }
end;

//Ecriture des paramtres de la fentre conversion
procedure ecrit_ini_conversion;
begin
    { Boolean - lecture de valeurs de type boolen : }
    fichierini.WriteBool('convert','compresser',convert.compresser.Checked);
    fichierini.WriteBool('convert','ecraser',convert.ecraser_sans_confirm.Checked);

    { Integer - lecture de valeurs de type entier : }
    fichierini.WriteInteger('convert','nb_msa',convert.choix_nombre_msa.ItemIndex);

    { String - lecture de valeurs de type chane : }
end;

//Lecture des paramtres de la fentre disquette vierge
procedure lit_ini_disquette_vierge;
begin
    { Boolean - lecture de valeurs de type boolen : }
    disquette_vierge.ouvrir_disquette.Checked :=fichierini.ReadBool('disquette_vierge','ouvrir',true);

    { Integer - lecture de valeurs de type entier : }
    disquette_vierge.choix_entrees_rep_principal.ItemIndex :=fichierini.ReadInteger('disquette_vierge','entrees_rep',6);
    disquette_vierge.choix_faces.ItemIndex :=fichierini.ReadInteger('disquette_vierge','nb_faces',1);
    disquette_vierge.choix_pistes.ItemIndex :=fichierini.ReadInteger('disquette_vierge','nb_pistes',2);
    disquette_vierge.choix_secteurs.ItemIndex :=fichierini.ReadInteger('disquette_vierge','nb_secteurs',1);
    disquette_vierge.choix_secteurs_par_cluster.ItemIndex :=fichierini.ReadInteger('disquette_vierge','nb_secteurs_par_cluster',1);
    disquette_vierge.choix_secteurs_par_fat.ItemIndex :=fichierini.ReadInteger('disquette_vierge','nb_secteurs_par_fat',2);
    disquette_vierge.choix_taille_secteurs.ItemIndex :=fichierini.ReadInteger('disquette_vierge','taille_secteurs',2);

    { String - lecture de valeurs de type chane : }
end;

//Ecriture des paramtres de la fentre disquette vierge
procedure ecrit_ini_disquette_vierge;
begin
    { Boolean - lecture de valeurs de type boolen : }
    fichierini.WriteBool('disquette_vierge','ouvrir',disquette_vierge.ouvrir_disquette.Checked);

    { Integer - lecture de valeurs de type entier : }
    fichierini.WriteInteger('disquette_vierge','entrees_rep',disquette_vierge.choix_entrees_rep_principal.ItemIndex);
    fichierini.WriteInteger('disquette_vierge','nb_faces',disquette_vierge.choix_faces.ItemIndex);
    fichierini.WriteInteger('disquette_vierge','nb_pistes',disquette_vierge.choix_pistes.ItemIndex);
    fichierini.WriteInteger('disquette_vierge','nb_secteurs',disquette_vierge.choix_secteurs.ItemIndex);
    fichierini.WriteInteger('disquette_vierge','nb_secteurs_par_cluster',disquette_vierge.choix_secteurs_par_cluster.ItemIndex);
    fichierini.WriteInteger('disquette_vierge','nb_secteurs_par_fat',disquette_vierge.choix_secteurs_par_fat.ItemIndex);
    fichierini.WriteInteger('disquette_vierge','taille_secteurs',disquette_vierge.choix_taille_secteurs.ItemIndex);

    { String - lecture de valeurs de type chane : }
end;

//Lecture des paramtres de la fentre explorateur
procedure lit_ini_explorateur(fenetre:texplorer);
var
    strtemp:string;

begin
    { Boolean - lecture de valeurs de type boolen : }

    { Integer - lecture de valeurs de type entier : }
    fenetre.Top:=fichierini.ReadInteger('explorer','top',0);
    fenetre.Left:=fichierini.ReadInteger('explorer','left',255);
    fenetre.Width:=fichierini.ReadInteger('explorer','width',313);
    fenetre.Height:=fichierini.ReadInteger('explorer','height',520);
    fenetre.contenu.Width :=fichierini.ReadInteger('explorer','largeur_contenu',145);
    fenetre.contenu_repertoire.Columns[0].Width:=fichierini.ReadInteger('explorer','largeur_nom',158);
    fenetre.contenu_repertoire.Columns[1].Width:=fichierini.ReadInteger('explorer','largeur_taille',70);
    fenetre.contenu_repertoire.Columns[2].Width:=fichierini.ReadInteger('explorer','largeur_heure',70);
    fenetre.contenu_repertoire.Columns[3].Width:=fichierini.ReadInteger('explorer','largeur_date',70);

    { String - lecture de valeurs de type chane : }
    strtemp:=fichierini.ReadString('explorer','lecteur','c');
    fenetre.DriveComboBox1.Drive:=strtemp[1];
    strtemp:=fichierini.ReadString('explorer','windowstate','normal');
    if strtemp='maximized' then fenetre.WindowState:=wsmaximized;
end;

//Ecriture des paramtres de la fentre explorateur
procedure ecrit_ini_explorateur(fenetre:texplorer);
var
    strtemp:string;

begin
    { Boolean - lecture de valeurs de type boolen : }

    { Integer - lecture de valeurs de type entier : }
    if fenetre.WindowState<>wsmaximized then
    begin
        fichierini.WriteInteger('explorer','top',fenetre.Top);
        fichierini.WriteInteger('explorer','left',fenetre.Left);
        fichierini.WriteInteger('explorer','width',fenetre.Width);
        fichierini.WriteInteger('explorer','height',fenetre.Height);
    end;
    fichierini.WriteInteger('explorer','largeur_contenu',fenetre.contenu.Width);
    fichierini.WriteInteger('explorer','largeur_nom',fenetre.contenu_repertoire.Columns[0].Width);
    fichierini.WriteInteger('explorer','largeur_taille',fenetre.contenu_repertoire.Columns[1].Width);
    fichierini.WriteInteger('explorer','largeur_heure',fenetre.contenu_repertoire.Columns[2].Width);
    fichierini.WriteInteger('explorer','largeur_date',fenetre.contenu_repertoire.Columns[3].Width);

    { String - lecture de valeurs de type chane : }
    strtemp:=fenetre.DriveComboBox1.Drive;
    fichierini.WriteString('explorer','lecteur',strtemp);
    if fenetre.WindowState=wsmaximized then strtemp:='maximized' else strtemp:='normal';
    fichierini.WriteString('explorer','windowstate',strtemp);
end;

end.
